
; Automotive voltage interceptor

	ERRORLEVEL -302
	ERRORLEVEL -306

	list P=16F88
	#include p16f88.inc

;Program Configuration Register 1

; code protection
		__CONFIG    _CONFIG1, _CP_ALL & _CCP1_RB0  & _DEBUG_OFF & _WRT_PROTECT_ALL & _CPD_OFF & _LVP_OFF & _BODEN_OFF & _MCLR_ON & _PWRTE_ON & _WDT_OFF & _INTRC_IO
;Program Configuration Register 2
		__CONFIG    _CONFIG2, _IESO_OFF & _FCMEN_OFF

; using all 256 EEPROM storage for changes to output

; bank 0 RAM
BCD_0		equ	H'20'	; MS bcd value
BCD_1		equ	H'21'	; LS binary coded decimal value
BIN_0		equ	H'22'	; 8-bit binary value
TEMP		equ	H'23'	; data storage (BCD convert)
CNT_8		equ	H'24'	; counter in BCD routine
TEMP1		equ	H'25'	; delay storage value
OUTPUT		equ	H'26'	; output offset value
INPUT		equ	H'27'	; input value
MODE		equ	H'28'	; run or view mode
OUT1		equ	H'29'	; ms decimal display value
OUT2		equ	H'2A'	; mid decimal display value
OUT3		equ	H'2B'	; ls decimal display value
STORE1		equ	H'2C'	; delay counter	
STORE2		equ	H'2D'	; delay counter
STORE3		equ	H'2E'	; delay counter
D_STO		equ	H'2F'	; display data storage
ADDRESS	equ	H'30'	; LCD address position
BATTERY	equ	H'31'	; battery voltage
START_FLG	equ	H'32'	; startup flag
SW_VAL	equ	H'33'	; switch value
SW_VAL1	equ	H'34'	; previous switch value
SWITCH_FLG equ H'35'	; switch pressed flag
VIEW		equ	H'36'	; input viewing value
CONVERSION equ H'37'	; A/D conversion counter
STEP		equ	H'38'	; step increment or decrement value
E_COUNT	equ	H'39'	; counter to provide default settings in all EEPROM locations
OUT_SIDE	equ	H'3A'	; output value for side values
ADD_STO	equ	H'3B'	; address storage for EEADR for side value changes
SW_CHNG	equ	H'3C'	; switch changed flag
STORE4		equ	H'3D'	; delay counter	
STORE5		equ	H'3E'	; delay counter
STORE6		equ	H'3F'	; delay counter
PORTB_STO	equ	H'40'	; PORTB storage
IN_STO		equ	H'41'	; input value store
VW_FLAG	equ	H'42'	; view run flag to add delay 
OUTPUT1	equ	H'43'	; run output value
LOOP		equ	H'44'	; delay loop
DELAY_FLG	equ	H'45'	; delay flag
UPDATE_DSP equ H'46'	; display update counter
SLOW		equ	H'47'	; switch delay timer
SLOW_R	equ	H'48'	; switch delay extra timer
RES_DEL	equ	H'49'	; reset delay
SAMPLE	equ	H'4A'	; battery voltage samples 
RELAY		equ	H'4B'	; relay on flag
SW_COUNT	equ	H'4C'	; switch counter, switch pressed for extended period
XTRA		equ	H'4D'	; extra count in delay
READ		equ	H'4E'	; battery read flag

; All Banks RAM
ST_ADR		equ	H'70'	; storage of EEPROM Address during interrupt
EDTA_ST	equ	H'71'	; EEPROM data store
W_TMP		equ	H'72'	; storage of w before interrupt
STATUS_TMP	equ	H'73'	; status storage before interrupt
WRITE_FLAG	equ	H'74'	; flag to indicate when EEPROM write in progress
	
	ORG     H'2100'
; set all EEPROM locations at 0 change

 ; 8 columns x 32 rows = 256 ie using all of the EEPROM locations for the map

	DE	D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128'
	DE	D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128'
	DE	D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128'
	DE	D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128'
	DE	D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128'
	DE	D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128'
	DE	D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128'
	DE	D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128'
	DE	D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128'
	DE	D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128'
	DE	D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128'
	DE	D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128'
	DE	D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128'
	DE	D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128'
	DE	D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128'
	DE	D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128'
	DE	D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128'
	DE	D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128'
	DE	D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128'
	DE	D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128'
	DE	D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128'
	DE	D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128'
	DE	D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128'
	DE	D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128'
	DE	D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128'
	DE	D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128'
	DE	D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128'
	DE	D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128'
	DE	D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128'
	DE	D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128'
	DE	D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128'
	DE	D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128'

; ******************************************************************

; start at memory 0

	org		0			; reset vector
	goto	MAIN		; byte 1

	nop
	nop
	nop	

	org     4			; interrupt vector
INTERRUPT
; store w and status registers 
	movwf	W_TMP			; w to w_tmp storage
	swapf	STATUS,w		; status to w
	movwf	STATUS_TMP	; status in status_tmp
	bcf		STATUS,RP0 
	bsf		STATUS,RP1	; bank 2 
	movf	EEADR,w		; EEPROM address
	movwf	ST_ADR
	movf	EEDATA,w		; EEPROM data
	movwf	EDTA_ST		; store value
	bcf		STATUS,RP0	; select bank 0
	bcf		STATUS,RP1

; display update timer decrease
	movf	UPDATE_DSP,w
	btfsc	STATUS,Z		; when zero do not decrease
	goto	SLOW_CHNG
	decf	UPDATE_DSP,f
SLOW_CHNG
; switch update timer decrease
	movf	SLOW,w
	btfsc	STATUS,Z
	goto	ANALOG
	
	movf	SLOW_R,w	; extra divider	
	btfss	STATUS,Z
	goto	DEC_R		; if not zero bypass reducing SLOW counter
	movlw	D'5'
	movwf	SLOW_R
	decf	SLOW,f	; 
	goto	ANALOG
DEC_R
	decf	SLOW_R,f	; decrease extra divider	
ANALOG
	
	btfss	START_FLG,0	; when set can read AN1 unless EEPROM is being written to
	goto	PWM_RAMP
	btfsc	WRITE_FLAG,0	; if flag set bypass as EEPROM is being writen
	goto 	PWM_RAMP

; if SWITCH_FLG,0 set then bypass A/D
	btfsc	SWITCH_FLG,0
	goto	LOOK

; if relay off bypass A/D
	btfss	RELAY,1
	goto	LOOK

; measure input at AN1, place in INPUT
; Channel 1 A/D value

	call		ACQUIRE_AD
	movf	ADRESH,w
	movwf	INPUT

; look up EEPROM value for that input and place in OUTPUT. 

LOOK
	movf	INPUT,w
	call		EEREAD	; Input value determines the EEPROM
	movwf	OUTPUT1	; new output

; PWM changes in interrupt

PWM_RAMP
; change PWM to match output value
; slower output change rate assured due to PWM filtering response
 
	comf	OUTPUT1,w	; output
	movwf	CCPR1L		; PWM	
	
RECLAIM
	bsf		STATUS,RP1	; select bank 2
	movf	ST_ADR,w	; EEPROM address store
;	btfss	WRITE_FLAG,0; if write EEPROM flag set bypass 
	movwf	EEADR		; return to original address
	movf	EDTA_ST,w	; EEPROM data store 
;	btfss	WRITE_FLAG,0; if write EEPROM flag set bypass 
	movwf	EEDATA
	bcf		STATUS,RP1	; select bank 0
	bcf		INTCON,TMR0IF	; clear TMRO interrupt flag
	swapf	STATUS_TMP,w; status temp storage to w
	movwf	STATUS		; w to status register
	swapf	W_TMP,f		; swap upper and lower 4-bits in w_tmp
	swapf   	W_TMP,w		; swap bits and into w register
	retfie				; return from interrupt

;******************************************************************************************* 
MAIN

	clrf		PORTB			; all low
	clrf		PORTA
	bsf		STATUS,RP0	; select memory bank 1

; set inputs/outputs
	movlw	B'00000111'	; comparators off
	movwf	CMCON
	movlw	B'00001110'	; port B outputs/ inputs set 
	movwf	TRISB		; port B data direction register
	movlw	B'00111110'	; outputs (0) and inputs (1)
	movwf	TRISA		; port A data direction register
	movlw	B'00000001'	; settings (pullups enabled TMR0/4)
	movwf	OPTION_REG

; analog inputs, A/D

	movlw	B'00011110'		; AN1,2,3,4 analog inputs (AN2, AN3 for REF-, REF+)
	movwf	ANSEL
;	movlw	B'01110000'		; left justified A/D result, Ref- and Ref+ used once relay switched on
	movlw	B'01000000'		; left justified, references 0V and 5V
	movwf	ADCON1
	bcf		STATUS,RP0	; select memory bank 0
	movlw	B'01100000' 		; Fosc, channel 1 etc
	movwf	ADCON0
	bsf		ADCON0,ADON	; A/D on
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'01111000'		; for 8MHz
	movwf	OSCCON		; osc
; pwm set
	movlw	H'FD'
	movwf	PR2				; PWM period register
	bcf		STATUS,RP0	; memory bank 0
	movlw	D'128'			; 50% duty for zero change 
	movwf	CCPR1L		; ms byte of PWM
	movlw	B'00000000'
	movwf	T2CON
	bsf		T2CON,2		; enable timer 2
	movlw	B'00001100'		; set PWM mode
	movwf	CCP1CON		; enable PWM operation

; Initial
	clrf		MODE			; initial mode is /run
	clrf		INPUT			; initial input = 0
	clrf		OUTPUT			; initial output
	movlw	D'128'
	movwf	OUTPUT1		; working output
	clrf		VIEW			; initial viewing input 0
	clrf		START_FLG		; startup flag
	clrf		RELAY			; relay flag	
	clrf		WRITE_FLAG	; EEPROM write flag
	clrf		SW_CHNG		; switch changed flag
	clrf		VW_FLAG		; view run flag
	clrf		SWITCH_FLG	; switch pressed flag
	clrf		SLOW_R		; switch delay extra timer
	clrf		SLOW			; switch delay timer
	movlw	D'200'			; battery voltage samples
	movwf	SAMPLE
	clrf		READ			; battery read flag

; set up initial conditions for display

SETUP
	call		INIT_LC	
	movlw	H'FF'		; start up delay
	call		DELAYX
	call		INIT_LC
	call		DELAYms
	call		INIT_LC
	call		DELAYms

	movlw	B'00101100'	; display function (4-bits, 2 lines, 5x10 dots)
	call		LOAD
	movlw	B'00001110'	; blinking off, cursor off
	call		LOAD
	movlw	B'00000001'	; display clear
	call		LOAD
	movlw	H'FF'		; delay 
	call		DELAYX		; 
	movlw	B'00000110'	; entry mode. cursor moves right, display not shifted
	call		LOAD
	movlw	B'00001110'	; blinking off, cursor off
	call		LOAD
	movlw	B'00101100'	; display function (4-bits, 2 lines, 5x10 dots)
	call		LOAD		; 
	movlw	B'00000001'	; display clear
	call		LOAD

	call		INIT_LC	
	movlw	H'FF'		; start up delay
	call		DELAYX
	call		INIT_LC
	call		DELAYms
	call		INIT_LC
	call		DELAYms

	movlw	B'00101100'	; display function (4-bits, 2 lines, 5x10 dots)
	call		LOAD
	movlw	B'00001110'	; blinking off, cursor off
	call		LOAD
	movlw	B'00000001'	; display clear
	call		LOAD
	movlw	H'FF'		; delay 
	call		DELAYX		; 
	movlw	B'00000110'	; entry mode. cursor moves right, display not shifted
	call		LOAD
	movlw	B'00001110'	; blinking off, cursor off
	call		LOAD
	movlw	B'00101100'	; display function (4-bits, 2 lines, 5x10 dots)
	call		LOAD		; 
	movlw	B'00000001'	; display clear
	call		LOAD

	call		INIT_LC	
	movlw	H'FF'		; start up delay
	call		DELAYX
	call		INIT_LC
	call		DELAYms
	call		INIT_LC
	call		DELAYms

	movlw	B'00101100'	; display function (4-bits, 2 lines, 5x10 dots)
	call		LOAD
	movlw	B'00001110'	; blinking off, cursor off
	call		LOAD
	movlw	B'00000001'	; display clear
	call		LOAD
	movlw	H'FF'		; delay 
	call		DELAYX		; 
	movlw	B'00000110'	; entry mode. cursor moves right, display not shifted
	call		LOAD
	movlw	B'00001110'	; blinking off, cursor off
	call		LOAD
	movlw	B'00101100'	; display function (4-bits, 2 lines, 5x10 dots)
	call		LOAD		; 
	movlw	B'00000001'	; display clear
	call		LOAD


	movlw	H'FF'		; delay 
	call		DELAYX

	call		CH_GEN	; generate a delta symbol (small triangle)

; allow interrupts
ALL_INTERRUPTS
	bsf		INTCON,TMR0IE	; timer 0 interrupt enable
	bsf 		INTCON,GIE		; set global interrupt enable 

; set A/D to channel 4, measure battery Voltage
VOLT_LOOP
; delay first
	movlw	D'20'
	movwf	XTRA
	call		DELAYSW

; bits 5 4 3
; ch4 1 0 0
	bcf		ADCON0,3
	bcf		ADCON0,4
	bsf		ADCON0,5

; Channel 4 A/D value
	call		ACQUIRE_AD
	movf	ADRESH,w

; check if battery already read for initial power up battery reading
	btfsc	READ,0
	goto	CK_LIMIT
; add 0.5V to Battery. ie add 9  (0.5V is divided by 3  with voltage divider)
	addlw	D'9'			; 0.5V 
	btfsc	STATUS,C	; if over 255 set at 255	
	movlw	D'255'
	movwf	BATTERY
	bsf		READ,0		; set read flag

CK_LIMIT ; (max volts)

; 13.5V? use  D221 (with input diode drop considered)
	sublw	D'221'
	btfss	STATUS,C	; if negative, then battery Volts greater than 13.5V 
	goto	CL_RLY		; close relay, as engine started already
	movlw	D'5'			; delay 
	call		DELAYX

COMPARE	
;  BATTERY	Voltage rises when engine starts and alternator charges	
;  When battery voltage is over 0.5V threshold, close relay.

	call		ACQUIRE_AD
	movf	ADRESH,w		; battery voltage
	subwf	BATTERY,w 
	btfss	STATUS,C		; if positive then battery is over threshold setting
	goto	REDUCE_SAMPLE_COUNT
	movlw	D'20'			; battery voltage samples
	movwf	SAMPLE		; restart voltage sample count if detects below threshold
	goto	SW_RUN

; voltage needs to be over threshold for 200 samples before closing relay

REDUCE_SAMPLE_COUNT
	decfsz	SAMPLE,f
	goto	SW_RUN

; close relay
CL_RLY
	bsf		PORTA,6		; relay closed
	bsf		RELAY,1		; relay flag 
	call		RUN			;  set A/D for REF+ and REF- range
	goto	START
;................................................................
RUN
; set A/D for REF+ and REF- range
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'01110000'		; left justified A/D result, Ref- and ref+ used once relay switched on
	movwf	ADCON1
	bcf		STATUS,RP0	; select memory bank 0

; set for channel 1
; bits  5 4 3
; ch4  0 0  1
	bsf		ADCON0,3
	bcf		ADCON0,4
	bcf		ADCON0,5
	return
;..............................................................

START
; if relay open check input volts
	btfss	RELAY,1
	goto	VOLT_LOOP		; check battery voltage for when to switch on relay

	bsf		START_FLG,0	; set 
SW_RUN
	movf	SLOW,w		; switch delay counter. If zero check switches
	btfss	STATUS,Z
	goto	NO_SWITCH_DELAY; bypass switch read during delay

; find closed switch 
FIND_CLOSED
	clrf		SW_VAL		; switch value cleared
; set RB6,RB5 and RB7 low
	bcf		PORTB,7
	nop
	bcf		PORTB,6
	nop
	bcf		PORTB,5

RECH_SW	
	movlw	D'20'		; add delay for voltage to rise
	movwf	LOOP
DEL	
	decfsz	LOOP,f
	goto	DEL	
	btfss	PORTB,3		; if low a switch is pressed
	goto	SW_PRESSED
	btfss	PORTB,2		; if low a switch is pressed
	goto	SW_PRESSED
	goto	NO_SWITCH
	
; place delay and check switch again 
SW_PRESSED	
	call		DELAYSW		; delay to ensure switch closure is not a glitch

	btfss	PORTB,3		; if low a switch is pressed
	goto	SW_Z
	btfsc	PORTB,2		; if low a switch is pressed
	goto	NO_SWITCH
SW_Z
	bsf		SWITCH_FLG,0	;  set flag 
	bsf		DELAY_FLG,0	; set when switch is pressed
	clrf		UPDATE_DSP	; display update counter clear

	clrf		SW_VAL
; find closed switch
; S4 & S2 check
; set RB6,RB5 high  and RB7 low
	bsf		PORTB,6
	nop
	bsf		PORTB,5
	nop
	bcf		PORTB,7
; wait for inputs to go high via weak pullup and 50pF input C
	call 		SHORT_T		; wait short time
	movlw	D'2'
	btfss	PORTB,3		; if low, switch 2 is pressed
	movwf	SW_VAL		; switch value
	movlw	D'4'
	btfss	PORTB,2		; if low, switch 4  is pressed
	movwf 	SW_VAL		; switch value

; S5 & S6 check
; set RB7,RB5 high  and RB6 low
	bsf		PORTB,7
	nop
	bsf		PORTB,5
	nop
	bcf		PORTB,6
; wait for inputs to go high via weak pullup and 50pF input C
	call 		SHORT_T		; wait short time
	movlw	D'5'
	btfss	PORTB,3		; if low, switch 5 is pressed
	movwf	SW_VAL		; switch value
	movlw	D'6'
	btfss	PORTB,2		; if low, switch 6  is pressed
	movwf 	SW_VAL		; switch value

 ; S1 & S3 check
; set RB7,RB6 high  and RB5 low
	bsf		PORTB,6
	nop
	bsf		PORTB,7
	nop
	bcf		PORTB,5
; wait for inputs to go high via weak pullup and 50pF input C
	call 		SHORT_T		; wait short time
	movlw	D'3'
	btfss	PORTB,3		; if low, switch 3 is pressed
	movwf	SW_VAL		; switch value
	movlw	D'1'
	btfss	PORTB,2		; if low, switch 1  is pressed
	movwf 	SW_VAL		; switch value
	
; if SW_VAL is zero then no switch closed
	movf	SW_VAL,w
	btfsc	STATUS,Z
	goto	NO_SWITCH

; SWITCH_FLG cleared when switches are open
; clear flag when not the same as last time 
; set if the same so the input does not change when altering values in RUN mode

	movf	SW_VAL,w	; switch value
	btfss	SWITCH_FLG,0; if clear then first time a switch was pressed after switches are open
	movwf	SW_VAL1		; previous switch value

	xorwf	SW_VAL1,w	; check if the same
	btfss	STATUS,Z
	goto	CK_SW
	bsf		SWITCH_FLG,0; same value so set flag 
 	goto	CK_SW

CK_SW
; check relay
	btfsc	RELAY,1		; if relay on normal switch check
	goto	NORMAL
	movf	MODE,w			; check mode only check all switches if in view mode
	btfss	STATUS,Z
	goto	NORMAL
	movf	SW_VAL,w		; otherwise limit switch access
	xorlw	H'05'
	btfsc	STATUS,Z
	goto	VW_DTA		; view/run modes 
	movf	SW_VAL,w
	xorlw	H'06'
	btfsc	STATUS,Z
	goto	DEF_LT			; default (reset)
	goto	DRV_DSP
NORMAL	
	movf	SW_VAL,w
	xorlw	H'02'	
	btfsc	STATUS,Z
	goto	UP_VARY		; up variation switch
	movf	SW_VAL,w
	xorlw	H'05'
	btfsc	STATUS,Z
	goto	VW_DTA		; view/run modes
	movf	SW_VAL,w
	xorlw	H'01'
	btfsc	STATUS,Z
	goto	LF_VIEW		; left view
	movf	SW_VAL,w
	xorlw	H'03'
	btfsc	STATUS,Z
	goto	DN_VARY		; down variation
	movf	SW_VAL,w
	xorlw	H'06'
	btfsc	STATUS,Z
	goto	DEF_LT			; default (reset)
	movf	SW_VAL,w
	xorlw	H'04'
	btfsc	STATUS,Z
	goto	RT_VIEW		; right view switch
	goto	DRV_DSP

; switch operations

; right view

RT_VIEW
	
	incf		SW_COUNT,f
	movf	SW_COUNT,w	
	sublw	D'5'
	btfss	STATUS,C	; if clear vary by 4
	goto	RT_VW2		
	movf	MODE,w		; check mode
	btfsc	STATUS,Z	; bypass if mode in run mode	
	goto	DRV_DSP		; run mode so do not alter
	movf	VIEW,w
	xorlw	D'255'		; if 255 already no increase
	btfsc	STATUS,Z
	goto	DRV_DSP
	incf		VIEW,f		; increase value
	goto	DRV_DSP

; right view larger step

RT_VW2
	decf	SW_COUNT,f	; stop from increasing beyond 255
	movf	MODE,w		; check mode
	btfsc	STATUS,Z	; bypass if mode in run mode	
	goto	DRV_DSP	; run mode so do not alter
	movlw	H'6'			; step increment
	movwf	STEP
INC_VW2
	movf	VIEW,w
	xorlw	D'255'		; if 255 already no increase
	btfsc	STATUS,Z
	goto	DRV_DSP
	incf		VIEW,f		; increase value
	decfsz	STEP,f		; next step
	goto	INC_VW2
	goto	DRV_DSP

; left view

LF_VIEW
	incf		SW_COUNT,f
	movf	SW_COUNT,w	
	sublw	D'5'
	btfss	STATUS,C	; if clear vary by 4
	goto	LF_VW2	
	movf	MODE,w		; check mode
	btfsc	STATUS,Z	; bypass if mode in run mode	
	goto	DRV_DSP	; run mode so do not alter
	movf	VIEW,w		; view position
	btfsc	STATUS,Z	; check for 0 or minimum
	goto	DRV_DSP
	decf	VIEW,f		; decrease value
	goto	DRV_DSP

; left view larger step

LF_VW2
	decf	SW_COUNT,f	; stop from increasing beyond 255
	movf	MODE,w		; check mode
	btfsc	STATUS,Z	; bypass if mode in run mode	
	goto	DRV_DSP	; run mode so do not alter
	movlw	H'06'		; step increment
	movwf	STEP
DEC_VW7
	movf	VIEW,w		; view position
	btfsc	STATUS,Z	; check for 0 or minimum
	goto	DRV_DSP
	decf	VIEW,f		; decrease value
	decfsz	STEP,f		; next step
	goto	DEC_VW7
	goto	DRV_DSP

; VIEW/RUN

VW_DTA
	movf	MODE,w		; check mode value
	btfss	STATUS,Z	; if zero change to 1
	goto	CLR_MD9	; clear mode
	incf		MODE,f		; change to a 1
	movf	INPUT,w		; transfer current input value
	movwf	VIEW		; to the view load site
	goto	SW_DLY
CLR_MD9
	clrf		MODE
SW_DLY
	bsf		VW_FLAG,0	; set view run flag

; close relaywhen view run switch pressed
	bsf		PORTA,6		; relay closed
	bsf		RELAY,1		; relay flag 
	call		RUN			; set A/D for REF+ and REF- range
	goto	DRV_DSP
				
; up variation switch					

UP_VARY
	incf		SW_COUNT,f
	movf	SW_COUNT,w	
	sublw	D'5'
	btfss	STATUS,C	; if clear vary by 5
	goto	UP_VRY2	
	movf	MODE,w		; check mode
	btfsc	STATUS,Z	; if zero run mode
	goto	RUN_MD1
	movf	VIEW,w		; viewing input value (1 to 255)
	goto	IN_VW1
RUN_MD1
	movf	INPUT,w 	; get current input value (1 to 255)
IN_VW1
	clrf		START_FLG	; start flag (prevents any eeprom read in interrupt)
	call		EEREAD	; get output value (routine sets EEADR)
	movwf	OUTPUT		; output variation value
	sublw	D'254' 		; maximum
	btfss	STATUS,C	; if c = 0 then at maximum
	goto	SET_MX1
	incf		OUTPUT,w	; increase value
	goto	WRI_UP1
SET_MX1
	 movlw	D'255'		; ensure value doesn't go above 255
WRI_UP1
	clrf		START_FLG	; start flag (prevents any eeprom read in interrupt)
	bsf		WRITE_FLAG,0; set EEPROM write flag
	call		EEWRITE		
	goto	DRV_DSP			

; up variation larger step

UP_VRY2
	decf	SW_COUNT,f	; stop from increasing beyond 255
	movlw	H'06'		; step increment
	movwf	STEP
MODE_1
	movf	MODE,w		; check mode
	btfsc	STATUS,Z	; if zero run mode
	goto	RUN_MD5
	movf	VIEW,w		; viewing input value (0 to 255)
	goto	IN_VW5
RUN_MD5
	movf	INPUT,w 	; get current input value (0 to 255)
IN_VW5
	clrf		START_FLG	; start flag (prevents any eeprom read in interrupt)
	call		EEREAD	; get output value (routine sets EEADR)
	movwf	OUTPUT		; output variation value
NXT5
	movf	OUTPUT,w
	sublw	D'254' 		; maximum
	btfss	STATUS,C	; if c = 0 then at maximum
	goto	SET_MX5
	incf		OUTPUT,f	; increase value
	decfsz	STEP,f
	goto	NEXT5
	decf	OUTPUT,f
	goto	DRV_DSP
NEXT5
	movf	OUTPUT,w
	clrf		START_FLG	; start flag (prevents any eeprom read in interrupt)
	bsf		WRITE_FLAG,0; set EEPROM write flag
	call		EEWRITE
	goto	MODE_1
SET_MX5
	movlw	D'255'		; ensure value doesn't go above 255
	clrf		START_FLG	; start flag (prevents any eeprom read in interrupt)
	bsf		WRITE_FLAG,0; set EEPROM write flag
	call		EEWRITE		
	goto	DRV_DSP

; down variation

DN_VARY
	incf		SW_COUNT,f
	movf	SW_COUNT,w	
	sublw	D'5'
	btfss	STATUS,C	; if clear vary by 5
	goto	DN_VRY2
	
	movf	MODE,w		; check mode
	btfsc	STATUS,Z	; if zero run mode
	goto	RUN_MD8
	movf	VIEW,w		; viewing input value (1 to 255)
	goto	IN_VW8
RUN_MD8
	movf	INPUT,w 	; get current input value (1 to 255)
IN_VW8
	clrf		START_FLG	; start flag (prevents any eeprom read in interrupt)
	call		EEREAD	; get output value (routine sets EEADR)
	movwf	OUTPUT
	decf	OUTPUT,w	; output variation value
	btfsc	STATUS,Z	; check if zero 
	goto	DRV_DSP	; already zero so bypass
	decf	OUTPUT,w
	clrf		START_FLG	; start flag (prevents any eeprom read in interrupt)
	bsf		WRITE_FLAG,0; set EEPROM write flag
	call		EEWRITE
	goto	DRV_DSP

; down variation larger step	

DN_VRY2
	decf	SW_COUNT,f	; stop from increasing beyond 255
	movlw	H'06'		; step increment
	movwf	STEP
MODE_3
	movf	MODE,w		; check mode
	btfsc	STATUS,Z	; if zero run mode
	goto	RUN_MD3
	movf	VIEW,w		; viewing input value (1 to 255)
	goto	IN_VW3
RUN_MD3	
	movf	INPUT,w 	; get current input value (1 to 255)
IN_VW3
	clrf		START_FLG		; start flag (prevents any eeprom read in interrupt)
	call		EEREAD		; get output value (routine sets EEADR)
	movwf	OUTPUT
NXT_3
	decf	OUTPUT,w	; output variation value
	btfsc	STATUS,Z	; check if zero 
	goto	DRV_DSP	; already zero so bypass
	decf	OUTPUT,w
	clrf		START_FLG	; start flag (prevents any eeprom read in interrupt)
	bsf		WRITE_FLAG,0; set EEPROM write flag
	call		EEWRITE
	decfsz	STEP,f
	goto	MODE_3	; next step
	decf	OUTPUT,f
	goto	DRV_DSP

; default of 0 offset
	
DEF_LT
	bsf		SW_CHNG,0	;  switch changed flag
	movlw	D'16'		;  2.5s delay
	movwf	STORE6
ROTAT
	call		DELAYSW		;  delay

; Check if Reset (S6) still pressed
; set RB7,RB5 high  and RB6 low
	bsf		PORTB,7
	nop
	bsf		PORTB,5
	nop
	bcf		PORTB,6
	clrf		SW_VAL
; wait for inputs to go high via weak pullup and 50pF input C
	call 		SHORT_T		; wait short time
	movlw	D'5'
	btfss	PORTB,3		; if low, switch 5 is pressed
	movwf	SW_VAL		; switch value
	movlw	D'6'
	btfss	PORTB,2		; if low, switch 6  is pressed
	movwf 	SW_VAL		; switch value

; if switch value is 6 then reset pressed
	movf	SW_VAL,w
	xorlw	D'6'
	btfss	STATUS,Z
	goto	DRV_DSP		; 
	bcf		SW_CHNG,0		;  clear switch changed flag
	decfsz	STORE6,f
	goto	ROTAT
; check lock
	btfss	PORTB,1		; RB1 low = lock
	goto	DRV_DSP		; no reset on lock

	
	movlw	H'80'			; address line 1
	call		LOAD
	movlw	A'R'		; R
	call		DRV_LCD
	movlw	A'E'		; E
	call		DRV_LCD
	movlw	A'S'		; S
	call		DRV_LCD
	movlw	A'E'		; E
	call		DRV_LCD
	movlw	A'T'		; T
	call		DRV_LCD
	call		SPACE4		; 4 spaces
	call		SPACE1		; 1 spaces

	movlw	A'0'		; 0
	call		DRV_LCD
	call		SPACE1		; 1 space
	movlw	A'('		; (
	call		DRV_LCD
	movlw	H'00'			; delta symbol
	call		DRV_LCD
	movlw	A'V'				; Voltage
	call		DRV_LCD
	movlw	A')'		; )
	call		DRV_LCD
	call		SPACE1		; 1 space

	bcf		INTCON,GIE		; clear global interrupt enable 
	clrf		E_COUNT		; EEPROM counter
	movlw	H'00'
	bsf		STATUS,RP1	; select bank 2
	movwf	EEADR			; set EEPROM1 address
	bcf		STATUS,RP1	; select bank 0
EE_LD
	movlw	D'128'			; no offset
	call		EWRITE			; set at 0 offset
	decfsz	E_COUNT,f
	goto	NXT_EE
	bsf		INTCON,GIE		; set global interrupt enable 
	goto	DRV_DLY
NXT_EE
	bsf		STATUS,RP1	; select bank 2	
	incf		EEADR,f		; next EEPROM location
	bcf		STATUS,RP1	; select bank 0
	goto	EE_LD

DRV_DLY	
	movlw	D'8'
	movwf	RES_DEL		; reset delay
DLY_RET	
	movlw	H'FF'
	call		DELAYX
	decfsz	RES_DEL,f
	goto	DLY_RET

; drive display with values

DRV_DSP
; check mode and relay
	movf	MODE,w
	btfss	STATUS,Z
	goto	SHOW_OUT		; show output for view mode
	btfsc	RELAY,1		; if relay on show output
	goto	SHOW_OUT		; show output for relay on

; show bypassed when run mode and relay open

 	movlw	H'80'		; address line 1
	call		LOAD
	movlw	A'B'		; 
	call		DRV_LCD
	movlw	A'y'		; 
	call		DRV_LCD
	movlw	A'p'		; 
	call		DRV_LCD
	movlw	A'a'		; 
	call		DRV_LCD
	movlw	A's'		; 
	call		DRV_LCD
	movlw	A's'		; 
	call		DRV_LCD
	call		SPACE1		; 1 space
	goto	DISP_F

SHOW_OUT;	(ADJUST)
	movlw	H'80'		; address line 1
	call		LOAD
	movlw	A'A'		; A
	call		DRV_LCD
	movlw	A'D'		; D
	call		DRV_LCD
	movlw	A'J'		; J
	call		DRV_LCD
	movlw	A'U'		; U
	call		DRV_LCD
	movlw	A'S'		; S
	call		DRV_LCD
	movlw	A'T'		; T
	call		DRV_LCD
	call		SPACE1		; 1 space
	
; get output value

DISP_F
	movf	MODE,w		; check mode
	btfsc	STATUS,Z	; if zero run mode
	goto	RN_MD
	movf	VIEW,w		; viewing input value (0 to 255)
	goto	IN_VW

RN_MD
	bcf		INTCON,GIE
	movf	INPUT,w		; input 
	movwf	IN_STO		; stored value
	movf	OUTPUT1,w	; value read in interrupt
	bsf		INTCON,GIE
	movwf	OUTPUT
	goto	SIGN	
	
IN_VW
	movwf	IN_STO		; stored value
	clrf		START_FLG	; start flag (prevents any eeprom read in interrupt)
	call		EEREAD	; get EEPROM value
	movwf	OUTPUT
SIGN
	btfsc	OUTPUT,7	; if bit 7 set then +
	goto	PLUS
	movf	OUTPUT,w
	sublw	H'80'		; display shows offset from 128
	movwf	OUTPUT		; 
	movlw	A'-'			; minus sign
	call		DRV_LCD
	goto	VALU
PLUS
	movf	OUTPUT,w
	xorlw	B'10000000'
	btfsc	STATUS,Z	; if zero add space and bypass + sign
	goto	ADDSPCE
	movlw	A'+'			; + sign
	call		DRV_LCD
	goto	VALU
ADDSPCE
	call		SPACE1		; space instead of +
	
VALU
	movf	OUTPUT,w	; output value
	andlw	B'01111111'	; extract only 7 bits (bit 7 is sign)	
	movwf	BIN_0		;
	call		BCD_ASCII	; get bcd/ASCII value
	movf	OUT1,w		; ms value
	xorlw	H'30'		; check if 0
	btfss	STATUS,Z
	goto	LOAD1
	call		SPACE1		; leading 0's to space

; mid digit

	movf	OUT2,w
	xorlw	H'30'			; is it zero
	btfss	STATUS,Z
	goto	LOAD2
	call		SPACE1		; leading 0's to space
	goto	LOAD3
LOAD1
	movf	OUT1,w
	call		DRV_LCD
LOAD2
	movf	OUT2,w
	call		DRV_LCD
LOAD3
	movf	OUT3,w
	call		DRV_LCD
	movlw	H'8B'			; address line 1 position 11
	call		LOAD
	call		SPACE1
; check lock
	btfss	PORTB,1		; PORTB,1 low = lock
	goto	LOCK_EE
	movlw	A'('		; (
	call		DRV_LCD
; check relay
	btfss	RELAY,1		; if relay on show delta V
	goto	NO_DELTA
	movlw	H'00'			; delta symbol
	call		DRV_LCD
	goto	VOLT_V
NO_DELTA ; no output change as relay open, show 0
	movlw	A'0'				; 0
	call		DRV_LCD

VOLT_V
	movlw	A'V'				; V for volt
	call		DRV_LCD
	movlw	A')'		; )
	call		DRV_LCD
	call		SPACE1		; 1 space
	goto	LN2

; lock EEPROM indicator
LOCK_EE
	movlw	A'L'		; L
	call		DRV_LCD
	movlw	A'O'		; O
	call		DRV_LCD
	movlw	A'C'		; C 
	call		DRV_LCD
	movlw	A'K'		; K
	call		DRV_LCD
	call		SPACE1		; 1 space

; line 2
LN2
	movlw	B'11000000'	; address line 2
	call		LOAD
	movlw	A'L'		; L
	call		DRV_LCD
	movlw	A'O'		; O
	call		DRV_LCD
	movlw	A'A'		; A
	call		DRV_LCD
	movlw	A'D'		; D
	call		DRV_LCD
	call		SPACE3		;  spaces
	
; get input value

RUN_MDX
	movf	IN_STO,w 	; get stored input value (0 to 255)
	movwf	BIN_0		;
	call		BCD_ASCII	; get ASCII values
	movf	OUT1,w		; ms digit (0 to 255 range)
	
; most significant digit check for leading 0 blanking

	xorlw	H'30'		; is it zero
	btfss	STATUS,Z
	goto	LOAD4
	call		SPACE1		; zero so add space
	goto	LOAD7		; load middle digit
LOAD4
	movf	OUT1,w		; not zero
	call		DRV_LCD
	goto	LOAD8		; if ms digit not zero end blanking of 0
LOAD7
	movf	OUT2,w		; middle digit
	xorlw	H'30'		; is it 0
	btfss	STATUS,Z
	goto	LOAD8
	call		SPACE1 
	goto	LOAD5
LOAD8	
	movf	OUT2,w		; not zero so load value
	call 		DRV_LCD
LOAD5
	movf	OUT3,w
	call		DRV_LCD

; check mode for run or view
	
	movf	MODE,w
	btfss	STATUS,Z	; if zero run mode
	goto	VIEW_M		; view mode
	call		SPACE1	; 1 space
	movlw	A'/'		; /
	call		DRV_LCD
	movlw	A'R'		; R
	call		DRV_LCD
	movlw	A'U'		; U
	call		DRV_LCD
	movlw	A'N'		; N	
	call		DRV_LCD
	movlw	A'/'		; /
	call		DRV_LCD
	goto	SW_DEL

VIEW_M
	movlw	A'<'		; <
	call		DRV_LCD
	movlw	A'V'		; V
	call		DRV_LCD
	movlw	A'I'		; I
	call		DRV_LCD
	movlw	A'E'		; E
	call		DRV_LCD
	movlw	A'W'	; W
	call		DRV_LCD
	movlw	A'>'		; >
	call		DRV_LCD

; delay between display update and switch operations

SW_DEL
	btfss	DELAY_FLG,0	; if set run delay as a switch is pressed
	goto	NO_SWITCH_DELAY	
	btfss	VW_FLAG,0		; if set more delay between switching View/Run
	goto	ST_DLY
	movlw	D'120'			; delay
	clrf		VW_FLAG		; clear
	goto	VIEW_RUN 
ST_DLY
	movlw	D'50'			;  DELAY for switch
VIEW_RUN
	movwf	SLOW
	movlw	D'5'
	movwf	SLOW_R		; extra timer
	clrf		DELAY_FLG		; delay flag cleared
	goto	START

NO_SWITCH		
	clrf		SWITCH_FLG	; flag cleared with no switch detection
	clrf		SW_COUNT		; switch counter

NO_SWITCH_DELAY 			; no switch check because of the switch debounce (update) delay
	movf	UPDATE_DSP,w
	btfss	STATUS,Z		; when zero run display update 
	goto	START			; bypass display update
	movlw	D'244'			; display update rate 250ms
; 976.56Hz /244 = 4Hz
	movwf	UPDATE_DSP	; start timer again
	goto	DRV_DSP		; display update
	
; xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx

; Subroutines

; subroutine to wait for conversion

ACQUIRE_AD
; wait for >20us
	movlw	D'40'
	movwf	CONVERSION
LOOP_CONV
	decfsz	CONVERSION,f	; decrease 
	goto	LOOP_CONV	
	bsf		ADCON0,2		; GO/DONE bit start conversion
WAIT_CONV
	btfsc	ADCON0,2		; conversion complete when cleared ~11 cycles
	goto	WAIT_CONV
	return


; add space in display

SPACE4
	movlw	H'20'		; space
	call		DRV_LCD
SPACE3
	movlw	H'20'		; space
	call		DRV_LCD
SPACE2
	movlw	H'20'		; space
	call		DRV_LCD
SPACE1
	movlw	H'20'		; space
	call		DRV_LCD
	return

; delay loops 
; short time
SHORT_T
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	return

DELAYms
	movlw	D'23'		; delay value
DELAYX
	movwf	STORE1		; STORE1 is number of loops value
LOOP8	
	movlw	D'70'
DELDSP
	movwf	STORE2		; STORE2 is internal loop value	
LOOP9
	decfsz	STORE2,f
	goto	LOOP9
	decfsz	STORE1,f
	goto	LOOP8		; decrease till STORE1 is zero
	return

DELAYSW
	movlw	D'01'
	movwf	XTRA
DELAYSW1
	movlw	D'255'		; delay value
	movwf	STORE1		; STORE1 is number of loops value
LOOP18	
	movlw	D'255'
	movwf	STORE2		; STORE2 is internal loop value	
LOOP19
	decfsz	STORE2,f
	goto	LOOP19
	decfsz	STORE1,f
	goto	LOOP18		; decrease till STORE1 is zero
	decfsz	XTRA,f
	goto	DELAYSW1
	return

; initialise display

INIT_LC
	movlw	B'1010000'		; initialise module
	movwf	PORTB
	nop
	bsf		PORTA,7		; enable high
	nop
	bcf		PORTA,7		; low
	return

; preload display commands (4-bit) 

LOAD
	movwf	D_STO			; store data	
	movf	D_STO,w
	andlw	H'F0'			; get upper bits
; place display commands in portB
	movwf	PORTB_STO
	bcf		PORTB,7
	bcf		PORTB,6
	bcf		PORTB,5
	bcf		PORTB,4
	btfsc	PORTB_STO,7
	bsf		PORTB,6	
	btfsc	PORTB_STO,6
	bsf		PORTB,5	
	btfsc	PORTB_STO,5
	bsf		PORTB,4	
	btfsc	PORTB_STO,4
	bsf		PORTB,7	

	bcf		PORTA,0		; register select low
	nop
	bsf		PORTA,7		; enable set
	nop
	bcf		PORTA,7		; enable clear

	swapf	D_STO,w
	andlw	H'F0'			; get lower bits
; place display commands in portB
	movwf	PORTB_STO
	bcf		PORTB,7
	bcf		PORTB,6
	bcf		PORTB,5
	bcf		PORTB,4
	btfsc	PORTB_STO,7
	bsf		PORTB,6	
	btfsc	PORTB_STO,6
	bsf		PORTB,5	
	btfsc	PORTB_STO,5
	bsf		PORTB,4	
	btfsc	PORTB_STO,4
	bsf		PORTB,7	
	bcf		PORTA,0		; register select low
	nop
	bsf		PORTA,7		; enable set
	nop
	bcf		PORTA,7		; enable clear
	goto	BUS_CK		; check busy flag
	
; driving the LCD module with display data

DRV_LCD	
	movwf	D_STO		; store data
	andlw	H'F0'		; upper bits
	movwf	PORTB_STO
	bcf		PORTB,7
	bcf		PORTB,6
	bcf		PORTB,5
	bcf		PORTB,4
	btfsc	PORTB_STO,7
	bsf		PORTB,6	
	btfsc	PORTB_STO,6
	bsf		PORTB,5	
	btfsc	PORTB_STO,5
	bsf		PORTB,4	
	btfsc	PORTB_STO,4
	bsf		PORTB,7	
	bsf		PORTA,0		; register select
	bsf		PORTA,7		; enable high
	nop
	bcf		PORTA,7		; enable low

	swapf	D_STO,w
	andlw	H'F0'			; lower bits
	movwf	PORTB_STO
	bcf		PORTB,7
	bcf		PORTB,6
	bcf		PORTB,5
	bcf		PORTB,4
	btfsc	PORTB_STO,7
	bsf		PORTB,6	
	btfsc	PORTB_STO,6
	bsf		PORTB,5	
	btfsc	PORTB_STO,5
	bsf		PORTB,4	
	btfsc	PORTB_STO,4
	bsf		PORTB,7	
	bsf		PORTA,0		; register select
	bsf		PORTA,7		; enable high
	nop
	bcf		PORTA,7		; enable low

BUS_CK
	movlw 	D'2'			; was 30
	movwf	STORE1		; delay values
	movlw	D'255'		; delay for busy flag to clear
	goto	DELDSP

; subroutine to read EEPROM memory 

EEREAD
	
	bcf		STATUS,RP0	; select bank 0
	bsf 		STATUS,RP1	; select memory bank 2
	movwf 	EEADR			; indirect special function register
	bsf 		STATUS,RP0	; select memory bank 3
	bcf		EECON1,EEPGD; data memory
	bsf		EECON1,RD		; read EEPROM
	bcf 		STATUS,RP0	; select memory bank 2
	movf	EEDATA,w		; EEPROM value in w
	bcf		STATUS,RP1	; select bank 0
	bsf		START_FLG,0	; start flag
	return

; subroutine to write to EEPROM interrupt not enabled
EWRITE
; check lock
	btfss	PORTB,1		; low = lock
	goto	BY_LOCK1	
	bcf 		STATUS,RP0	; bank 0
	bsf		STATUS,RP1	; select bank 2
	movwf	EEDATA		; data register
	bsf 		STATUS,RP0	; select memory bank 3
WR4	
	btfsc	EECON1,WR	; check if write complete 
	goto 	WR4			; not written yet
	bcf		INTCON,GIE		; disable interrupts
	bcf		EECON1,EEPGD; data memory
	bsf		EECON1,WREN	; enable write
	movlw	H'55'			; place 55H in w for write sequence
	movwf 	EECON2 		; write 55H to EECON2
	movlw 	H'AA'			; AAH to w
	movwf	EECON2		; write AA to EECON2
	bsf		EECON1,WR	; set WR bit and begin write sequence
	bcf		EECON1,WREN	; clear WREN bit

WRITE1
	btfsc	EECON1,WR	; skip if write complete 
	goto 	WRITE1			; not written yet
	bcf		EECON1,EEIF	; clear write interrupt flag
	bcf		STATUS,RP1	; 
	bcf 		STATUS,RP0	; select memory bank 0
BY_LOCK1
	bsf		START_FLG,0	; start flag
	clrf		WRITE_FLAG	; EEPROM written flag
	return					; value written
 
EEWRITE
; subroutine to write to EEPROM interrupt re-enabled	
; check lock
	btfss	PORTB,1		; low = lock
	goto	BY_LOCK	
	bcf 		STATUS,RP0	; bank 0
	bsf		STATUS,RP1	; select bank 2
	movwf	EEDATA		; data register
	bsf 		STATUS,RP0	; select memory bank 3
WR3	
	btfsc	EECON1,WR	; check if write complete 
	goto 	WR3			; not written yet
	bcf		INTCON,GIE		; disable interrupts
	bcf		EECON1,EEPGD; data memory
	bsf		EECON1,WREN	; enable write
	movlw	H'55'			; place 55H in w for write sequence
	movwf 	EECON2 		; write 55H to EECON2
	movlw 	H'AA'			; AAH to w
	movwf	EECON2		; write AA to EECON2
	bsf		EECON1,WR	; set WR bit and begin write sequence
	bcf		EECON1,WREN	; clear WREN bit
	bsf 		INTCON,GIE		; enable interrupts
WRITE
	btfsc	EECON1,WR	; skip if write complete 
	goto 	WRITE			; not written yet
	bcf		EECON1,EEIF	; clear write interrupt flag
	bcf		STATUS,RP1	; 
	bcf 		STATUS,RP0	; select memory bank 0
BY_LOCK	
	bsf		START_FLG,0	; start flag
	clrf		WRITE_FLAG	; EEPROM written flag
	return				 	; value written 

; Subroutine to convert from 8-bit binary to 2-digit BCD (packed)
; Binary value is in BIN_0  
; Result in BCD is in BCD_0 & BCD_1.  
; BCD_0 is MSB, BCD_1 is LSB
; converts to unpacked ASCII in OUT1, OUT2, OUT3 (out1 is ms byte, out3 is ls byte)

BCD_ASCII
	bcf		STATUS,C	; clear carry bit
	movlw	D'8'
	movwf	CNT_8		; 8 in count
	clrf		BCD_0
	clrf		BCD_1		; set BCD registers to 0 
LOOPBCD
	rlf		BIN_0,f		; shift left binary registers
	rlf		BCD_1,f		; MSB shift left

	rlf		BCD_0,f		; LSB shift left BCD registers
	decfsz	CNT_8,f		; reduce count value return when 0
	goto	DECADJ	; continue decimal adjust

; completed decimal to BCD operation, convert to unpacked ASCII
	
	movf	BCD_1,w	; ls decimal
	andlw	H'0F'		; ls
	addlw	H'30'		; convert to ASCII
	movwf	OUT3
	swapf	BCD_1,w 	; mid decimal value
	andlw	H'0F'
	addlw	H'30'		; convert to ASCII
	movwf	OUT2
	movf	BCD_0,w
	addlw	H'30'		; convert to ASCII
	movwf	OUT1		; ms decimal value
	return				; ASCII values returned in OUT1, OUT2, OUT3 

; subroutine decimal adjust

DECADJ
	movlw	BCD_1		; BCD LSB address
	movwf	FSR		; pointer for BCD1
	call		ADJBCD	; subroutine to adjust BCD
	movlw	BCD_0		; BCD MS address
	movwf	FSR		; pointer for BCD0
	call		ADJBCD
	goto	LOOPBCD

; subroutine adjust BCD

ADJBCD	
	movlw	H'03'		; w has 03 
	addwf	INDF,w		; add 03 to BCDx register (x is 0-1)
	movwf	TEMP		; store w
	btfsc	TEMP,3		; test if >7
	movwf	INDF		; save as LS digit
	movlw	H'30'		; 3 for MSbyte
	addwf	INDF,w		; add 30 to BCDx register
	movwf	TEMP		; store w in temp
	btfsc	TEMP,7		; test if >7
	movwf	INDF		; save as MS digit
	return				; end subroutine

; character generation	
CH_GEN
	movlw	B'01000000'	; address 0
	call	LOAD		; character gen delta
	movlw	B'00000000'
	call	DRV_LCD
	movlw	B'00000000'
	call	DRV_LCD
	movlw	B'00000000'
	call	DRV_LCD
	movlw	B'00000100'
	call	DRV_LCD
	movlw	B'00001010'
	call	DRV_LCD
	movlw	B'00011111'
	call	DRV_LCD
        movlw	B'00000000'
	call	DRV_LCD
	movlw	B'00000000'
	call	DRV_LCD
	return
        

	end
